﻿Partial Public Class StudentCard
    Inherits UserControl
    Private Shared studentCards As New List(Of StudentCard)()
    Private Shared contactTime As Integer
    Private Shared contactPoint As Point

    Public Shared ReadOnly IsOpenProperty As DependencyProperty =
        DependencyProperty.Register("IsOpen",
                                    GetType(Boolean),
                                    GetType(StudentCard),
                                    New PropertyMetadata(False, AddressOf OnIsOpenChanged))

    Shared Sub New()
        AddHandler Touch.FrameReported, AddressOf OnTouchFrameReported
    End Sub

    Private Shared Sub OnIsOpenChanged(ByVal obj As DependencyObject,
                                       ByVal args As DependencyPropertyChangedEventArgs)
        TryCast(obj, StudentCard).OnIsOpenChanged(args)
    End Sub

    Private Shared Sub OnTouchFrameReported(ByVal sender As Object,
                                            ByVal args As TouchFrameEventArgs)
        Dim touchPoint = args.GetPrimaryTouchPoint(Nothing)

        If touchPoint IsNot Nothing AndAlso touchPoint.Action = TouchAction.Down Then
            contactPoint = touchPoint.Position
            contactTime = args.Timestamp
        ElseIf touchPoint IsNot Nothing AndAlso touchPoint.Action = TouchAction.Up Then
            ' Check if finger is directly over StudentCard or child
            Dim element = touchPoint.TouchDevice.DirectlyOver

            Do While element IsNot Nothing AndAlso Not (TypeOf element Is StudentCard)
                element = VisualTreeHelper.GetParent(element)
            Loop

            If element Is Nothing Then
                Return
            End If

            ' Get lift point and calculate difference
            Dim liftPoint = touchPoint.Position
            Dim distance = Math.Sqrt(Math.Pow(contactPoint.X - liftPoint.X, 2) +
                                     Math.Pow(contactPoint.Y - liftPoint.Y, 2))

            ' Qualify as a Tap if distance < 12 pixels within 1/4 second
            If distance < 12 AndAlso args.Timestamp - contactTime < 250 Then
                ' Enumerate StudentCard objects and set IsOpen property
                For Each _studentCard In studentCards
                    _studentCard.IsOpen = (element Is _studentCard AndAlso
                                           (Not _studentCard.IsOpen))
                Next _studentCard
            End If
        End If
    End Sub

    Public Sub New()
        InitializeComponent()
        studentCards.Add(Me)
    End Sub

    Private Property IsOpen() As Boolean
        Set(ByVal value As Boolean)
            SetValue(IsOpenProperty, value)
        End Set
        Get
            Return CBool(GetValue(IsOpenProperty))
        End Get
    End Property

    Private Sub OnIsOpenChanged(ByVal args As DependencyPropertyChangedEventArgs)
        VisualStateManager.GoToState(Me, If(IsOpen, "Open", "Normal"), False)
    End Sub
End Class